# -*- coding=utf8 -*-
#******************************************************************************
# Server.py
#------------------------------------------------------------------------------
#
# Copyright (c) 2014-2017 LivingOn <LivingOn@xmail.net>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#******************************************************************************
import socket
import threading

from resources.lib import IPCData


class Server(threading.Thread):
    "Wartet im Hintergrund auf Aufnahmebefehle"

    PORT = 18517
    STOP_MARKER = 'STOP RUNNING THREAD'

    def __init__(self, queue):
        "Initialisiert den Server"
        threading.Thread.__init__(self)
        self._queue = queue

    def run(self):
        "Macht den Service nach Außen verfügbar"
        sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
        sock.setsockopt(socket.SOL_SOCKET, socket.SO_REUSEADDR, 1)
        server_address = ('localhost', self.PORT)
        sock.bind(server_address)
        sock.listen(1)
        while True:
            connection, client_address = sock.accept()
            try:
                data = connection.recv(1024)
                if data.startswith(self.STOP_MARKER):
                    break
                ipc = IPCData.loads(data)
                self._queue.put(ipc)
            finally:
                connection.close()

    def stop(self):
        "Beendet den Server"
        sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
        server_address = ('localhost', self.PORT)
        sock.connect(server_address)
        try:
            sock.sendall(self.STOP_MARKER)
        finally:
            sock.close()
