# -*- coding=utf8 -*-
#******************************************************************************
# Player.py
#------------------------------------------------------------------------------
#
# Copyright (c) 2014-2017 LivingOn <LivingOn@xmail.net>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#******************************************************************************
import sys
import urllib2
import threading

import xbmc
import xbmcgui
import xbmcvfs
import xbmcaddon


class Player(xbmc.Player):
    "Startet die Aufnahme und spielt diese ab"

    PLUGIN_NAME = 'service.chaturbate_recorder'
    SECONDS_TO_BUFFER = 8
    SECONDS_TO_TIMEOUT = 16

    RunningPlayer = None

    def __init__(self, *args):
        super(Player, self).__init__(self, *args)
        self._grabber = None
        self._addon = xbmcaddon.Addon(id = self.PLUGIN_NAME)

    def play_stream(self, url, seqnr, filename):
        "Starte Aufnahme und spiele sie ab"
        self._stop_old_player()
        self._start_grabber(url, seqnr, filename)
        self.play(filename)
        self._buffer_at_startup()

    def stop(self):
        "Beende Hintergrundthread"
        self._grabber.stop()

    def onPlayBackStopped(self, *args):
        "Beende Grabber wenn Stop gedrückt wird"
        self.stop()

    def onPlayBackEnded(self, *args):
        "Beende Grabber wenn Dateiende erreicht wird"
        self.stop()

    def _buffer_at_startup(self):
        "Sorge für genügend Abspielmaterial"
        self.pause()
        timeout_counter = 0
        try:
            while self.getTotalTime() <= self.SECONDS_TO_BUFFER:
                timeout_counter += 1
                if timeout_counter > self.SECONDS_TO_TIMEOUT:
                    break
                xbmc.sleep(1000)
            if self.getTotalTime() < 1:
                self._error_notification()
            self.pause()
        except:
            self.stop()
            self._error_notification()

    def _start_grabber(self, url, seqnr, filename):
        "Starte den Hintergrundthread zum Speichern der Chunks"
        self._grabber = _ChunkGrabber(url, seqnr, filename)
        self._grabber.start()
        self._buffering_notification()
        xbmc.sleep(3000)

    def _stop_old_player(self):
        "Nur ein Player darf z.Zt. laufen(/grabben)!"
        if self.RunningPlayer:
            self.RunningPlayer.stop()
        self.RunningPlayer = self

    def _buffering_notification(self):
        "Zeige Notification beim Buffern"
        xbmcgui.Dialog().notification(
            self._addon.getLocalizedString(30210),
            self._addon.getLocalizedString(30220),
            sound=False
        )

    def _error_notification(self):
        "Zeige Notification bei Error"
        xbmcgui.Dialog().notification(
            self._addon.getLocalizedString(30110),
            self._addon.getLocalizedString(30120),
            icon=xbmcgui.NOTIFICATION_ERROR,
            sound=True
        )


class _ChunkGrabber(threading.Thread):
    "Schreibt die Chunks in die Ausgabedatei"

    MILLISECONDS_TO_DELAY_AT_START = 1000
    MILLISECONDS_TO_DELAY_AT_RUN = 5000

    def __init__(self, streamurl, sequencenr, filename):
        "Initialisiert den ChunkGrabber"
        threading.Thread.__init__(self)
        self._filename = filename
        self._streamurl = streamurl
        self._sequencenr = sequencenr + 1
        self._stop_running_thread = False
        self._seconds_to_delay = self.MILLISECONDS_TO_DELAY_AT_START

    def run(self):
        "Speichert Chunks in die Ausgabedatei"
        filehandle = xbmcvfs.File(self._filename, "w")
        try:
            for i in xrange(self._sequencenr, sys.maxint):
                url = "%s%d.ts" % (self._streamurl, i)
                while True:
                    daten = self._get_daten(url)
                    if (daten):
                        filehandle.write(daten)
                        self._seconds_to_delay = self.MILLISECONDS_TO_DELAY_AT_RUN
                        break
                    else:
                        xbmc.sleep(self._seconds_to_delay)
                    if self._stop_running_thread:
                        break
                if self._stop_running_thread:
                    break
        finally:
            filehandle.close()

    def stop(self):
        "Thread soll beendet werden"
        self._stop_running_thread = True

    def _get_daten(self, url):
        "Liefert die Daten des Chunks"
        result = None
        try:
            result = urllib2.urlopen(url).read()
        except:
            pass
        return result

    def _stop_grabber(self):
        "Beende die Aufzeichnung"
        if self._grabber:
            self._grabber.stop()

